(function(global){"use strict";class TimePickerJS{constructor(element,options={}){this.element=typeof element==="string"?document.querySelector(element):element;if(!this.element){throw new Error("TimePickerJS: No element found")}this.defaults={className:null,minTime:null,maxTime:null,durationTime:null,step:30,showDuration:false,showOnFocus:true,disableTimeRanges:[],disableTextInput:false,disableTouchKeyboard:false,forceRoundTime:false,scrollDefault:null,selectOnBlur:false,typeaheadHighlight:true,noneOption:false,orientation:"l",timeFormat:"g:ia",dropdown:true,dynamicDropdown:false,container:document.body,useSelect:false,closeOnWindowScroll:false,appendTo:null,useNativeOnMobile:true};this.settings=Object.assign({},this.defaults,options);this.selectedValue=null;this.list=null;this.listCreated=false;this.selectedIndex=-1;this.isOpen=false;this.timeInput=null;this.originalType=this.element.type;this.isMobile=/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);this._onFocus=this._onFocus.bind(this);this._onBlur=this._onBlur.bind(this);this._onInput=this._onInput.bind(this);this._onKeydown=this._onKeydown.bind(this);this._onClick=this._onClick.bind(this);this._onWindowScroll=this._onWindowScroll.bind(this);this._onWindowResize=this._onWindowResize.bind(this);this._onTimeInputChange=this._onTimeInputChange.bind(this);this._init()}static create(selector,options={}){return TimePickerJSFactory(selector,options)}_init(){if(this.settings.useNativeOnMobile&&this.isMobile){this._setupNativeTimeInput()}this._bindEvents();if(this.element.value){this.setTimeFromString(this.element.value)}}_setupNativeTimeInput(){if(this.element.type==="time"){this.timeInput=this.element;return}this.timeInput=document.createElement("input");this.timeInput.type="time";this.timeInput.className="timepickerjs-native-input";this.element.parentNode.insertBefore(this.timeInput,this.element.nextSibling);if(this.element.value){const secondsValue=this._timeStringToSeconds(this.element.value);if(secondsValue!==null){const hours=Math.floor(secondsValue/3600);const minutes=Math.floor(secondsValue%3600/60);this.timeInput.value=`${hours.toString().padStart(2,"0")}:${minutes.toString().padStart(2,"0")}`}}this.timeInput.addEventListener("change",this._onTimeInputChange);this.timeInput.addEventListener("input",this._onTimeInputChange)}_onTimeInputChange(){if(!this.timeInput||!this.timeInput.value)return;const[hours,minutes]=this.timeInput.value.split(":").map(Number);const seconds=(hours*60+minutes)*60;this.selectedValue=seconds;this.element.value=this._formatTime(seconds);this._triggerEvent("change")}_createList(){if(this.listCreated)return;this.list=document.createElement("div");this.list.className="timepickerjs-list";if(this.settings.className){this.list.classList.add(this.settings.className)}this.list.style.display="none";this._generateOptions();const container=this.settings.appendTo||this.settings.container;container.appendChild(this.list);this.listCreated=true}_generateOptions(){const startTime=this.settings.minTime?this._timeStringToSeconds(this.settings.minTime):0;let endTime=this.settings.maxTime?this._timeStringToSeconds(this.settings.maxTime):24*60*60-1;if(endTime<=startTime){endTime+=24*60*60}const step=this.settings.step*60;this.list.innerHTML="";if(this.settings.noneOption){const noneItem=document.createElement("div");noneItem.className="timepickerjs-item";noneItem.textContent=typeof this.settings.noneOption==="string"?this.settings.noneOption:"None";noneItem.dataset.seconds="-1";noneItem.addEventListener("click",()=>{this.selectValue(-1);this.hideList()});this.list.appendChild(noneItem)}for(let seconds=startTime;seconds<=endTime;seconds+=step){if(this._isTimeDisabled(seconds)){continue}const item=document.createElement("div");item.className="timepickerjs-item";item.dataset.seconds=seconds%(24*60*60);const timeText=this._formatTime(seconds);let displayText=timeText;if(this.settings.showDuration){const duration=this._formatDuration(seconds-startTime);const durationSpan=document.createElement("span");durationSpan.className="timepickerjs-duration";durationSpan.textContent=duration;item.textContent=timeText+" ";item.appendChild(durationSpan)}else{item.textContent=displayText}item.addEventListener("click",()=>{this.selectValue(item.dataset.seconds);this.hideList()});this.list.appendChild(item)}}_bindEvents(){if(this.settings.useNativeOnMobile&&this.isMobile&&this.timeInput){this.element.addEventListener("click",e=>{e.preventDefault();this.timeInput.focus();this.timeInput.click()});this.element.addEventListener("focus",e=>{e.preventDefault();this.timeInput.focus();this.timeInput.click()});return}this.element.addEventListener("click",this._onClick);this.element.addEventListener("focus",this._onFocus);this.element.addEventListener("blur",this._onBlur);this.element.addEventListener("input",this._onInput);this.element.addEventListener("keydown",this._onKeydown);if(this.settings.closeOnWindowScroll){window.addEventListener("scroll",this._onWindowScroll)}window.addEventListener("resize",this._onWindowResize)}_onClick(){if(!this.isOpen){this.showList()}}_onFocus(){if(this.settings.showOnFocus&&!this.isOpen){this.showList()}if(this.settings.disableTouchKeyboard){this.element.blur()}}_onBlur(e){if(e.relatedTarget&&this.list&&(e.relatedTarget===this.list||e.relatedTarget.closest(".timepickerjs-list"))){return}setTimeout(()=>{if(this.settings.selectOnBlur&&this.selectedIndex>=0&&this.list){const items=this.list.querySelectorAll(".timepickerjs-item");if(items[this.selectedIndex]){this.selectValue(items[this.selectedIndex].dataset.seconds)}}this.hideList()},100)}_onInput(){if(this.settings.disableTextInput){return}this.setTimeFromString(this.element.value)}_onKeydown(e){if(!this.listCreated){if(e.key==="Enter"||e.key==="ArrowDown"||e.key==="ArrowUp"){this.showList();e.preventDefault()}return}if(!this.isOpen){if(e.key==="Enter"||e.key==="ArrowDown"||e.key==="ArrowUp"){this.showList();e.preventDefault()}return}switch(e.key){case"Enter":if(this.selectedIndex>=0){const items=this.list.querySelectorAll(".timepickerjs-item");if(items[this.selectedIndex]){this.selectValue(items[this.selectedIndex].dataset.seconds)}}this.hideList();e.preventDefault();break;case"Escape":this.hideList();e.preventDefault();break;case"ArrowDown":this.selectedIndex=Math.min(this.selectedIndex+1,this.list.children.length-1);this.highlightItem(this.selectedIndex);this.scrollToItem(this.selectedIndex);e.preventDefault();break;case"ArrowUp":this.selectedIndex=Math.max(this.selectedIndex-1,0);this.highlightItem(this.selectedIndex);this.scrollToItem(this.selectedIndex);e.preventDefault();break}}_onWindowScroll(){if(this.isOpen){this.hideList()}}_onWindowResize(){if(this.isOpen){this.positionList()}}showList(){if(this.settings.useNativeOnMobile&&this.isMobile&&this.timeInput){this.timeInput.focus();this.timeInput.click();return}if(!this.listCreated){this._createList()}if(this.isOpen||!this.list){return}this.positionList();this.list.style.display="block";this.isOpen=true;if(this.selectedValue!==null){const items=this.list.querySelectorAll(".timepickerjs-item");for(let i=0;i<items.length;i++){if(parseInt(items[i].dataset.seconds)===this.selectedValue){this.selectedIndex=i;this.highlightItem(i);this.scrollToItem(i);break}}}else if(this.settings.scrollDefault){const defaultTime=this._timeStringToSeconds(this.settings.scrollDefault);const items=this.list.querySelectorAll(".timepickerjs-item");for(let i=0;i<items.length;i++){if(parseInt(items[i].dataset.seconds)>=defaultTime){this.selectedIndex=i;this.highlightItem(i);this.scrollToItem(i);break}}}this._triggerEvent("open")}hideList(){if(!this.isOpen||!this.list){return}this.list.style.display="none";this.isOpen=false;this._triggerEvent("close")}positionList(){if(!this.list)return;const inputRect=this.element.getBoundingClientRect();const scrollTop=window.pageYOffset||document.documentElement.scrollTop;const scrollLeft=window.pageXOffset||document.documentElement.scrollLeft;this.list.style.position="absolute";this.list.style.top=`${inputRect.bottom+scrollTop}px`;if(this.settings.orientation==="r"){this.list.style.left=`${inputRect.right-this.list.offsetWidth+scrollLeft}px`}else{this.list.style.left=`${inputRect.left+scrollLeft}px`}this.list.style.width=`${inputRect.width}px`}highlightItem(index){if(!this.list)return;const items=this.list.querySelectorAll(".timepickerjs-item");items.forEach(item=>{item.classList.remove("active")});if(index>=0&&index<items.length){items[index].classList.add("active")}}scrollToItem(index){if(!this.list)return;const items=this.list.querySelectorAll(".timepickerjs-item");if(index>=0&&index<items.length){const item=items[index];const listRect=this.list.getBoundingClientRect();const itemRect=item.getBoundingClientRect();if(itemRect.top<listRect.top){this.list.scrollTop=this.list.scrollTop-(listRect.top-itemRect.top)}else if(itemRect.bottom>listRect.bottom){this.list.scrollTop=this.list.scrollTop+(itemRect.bottom-listRect.bottom)}}}selectValue(seconds){seconds=parseInt(seconds);if(seconds===-1){this.element.value="";this.selectedValue=null;if(this.timeInput){this.timeInput.value=""}}else{this.selectedValue=seconds;const formattedTime=this._formatTime(seconds);this.element.value=formattedTime;if(this.timeInput){const hours=Math.floor(seconds/3600);const minutes=Math.floor(seconds%3600/60);this.timeInput.value=`${hours.toString().padStart(2,"0")}:${minutes.toString().padStart(2,"0")}`}}this._triggerEvent("change")}setTimeFromString(timeString){if(!timeString){this.selectedValue=null;if(this.timeInput){this.timeInput.value=""}return}const seconds=this._timeStringToSeconds(timeString);if(seconds!==null){this.selectedValue=seconds;this.element.value=this._formatTime(seconds);if(this.timeInput){const hours=Math.floor(seconds/3600);const minutes=Math.floor(seconds%3600/60);this.timeInput.value=`${hours.toString().padStart(2,"0")}:${minutes.toString().padStart(2,"0")}`}}}_timeStringToSeconds(timeString){if(!timeString){return null}if(/^\d{1,2}:\d{2}:\d{2}$/.test(timeString)){const[hours,minutes]=timeString.split(":").map(Number);return hours*3600+minutes*60}if(/^\d{1,2}:\d{2}$/.test(timeString)){const[hours,minutes]=timeString.split(":").map(Number);return hours*3600+minutes*60}if(/^\d{1}:\d{2}$/.test(timeString)){const[hours,minutes]=timeString.split(":").map(Number);return hours*3600+minutes*60}const timeRegex=/(\d+)(?::(\d+))?(?::(\d+))?\s*(am|pm|AM|PM)?/i;const match=timeString.toLowerCase().match(timeRegex);if(!match){return null}let hours=parseInt(match[1]);const minutes=match[2]?parseInt(match[2]):0;const ampm=match[4];if(ampm){if(hours===12&&ampm.toLowerCase()==="am"){hours=0}else if(hours!==12&&ampm.toLowerCase()==="pm"){hours+=12}}return hours*3600+minutes*60}_formatTime(seconds){const totalSeconds=seconds%(24*60*60);const hours=Math.floor(totalSeconds/3600);const minutes=Math.floor(totalSeconds%3600/60);switch(this.settings.timeFormat){case"g:ia":const period=hours>=12?"pm":"am";const hour12=hours%12||12;return`${hour12}:${minutes.toString().padStart(2,"0")}${period}`;case"g:i A":const period2=hours>=12?"PM":"AM";const hour12_2=hours%12||12;return`${hour12_2}:${minutes.toString().padStart(2,"0")} ${period2}`;case"H:i":return`${hours.toString().padStart(2,"0")}:${minutes.toString().padStart(2,"0")}`;case"h:i A":const period3=hours>=12?"PM":"AM";const hour12_3=hours%12||12;return`${hour12_3.toString().padStart(2,"0")}:${minutes.toString().padStart(2,"0")} ${period3}`;default:const period4=hours>=12?"pm":"am";const hour12_4=hours%12||12;return`${hour12_4}:${minutes.toString().padStart(2,"0")}${period4}`}}_formatDuration(seconds){const hours=Math.floor(seconds/3600);const minutes=Math.floor(seconds%3600/60);if(hours>0){return`${hours}h ${minutes}m`}else{return`${minutes}m`}}_isTimeDisabled(seconds){if(!this.settings.disableTimeRanges||!this.settings.disableTimeRanges.length){return false}const timeInSeconds=seconds%(24*60*60);for(const range of this.settings.disableTimeRanges){const startSeconds=this._timeStringToSeconds(range[0]);const endSeconds=this._timeStringToSeconds(range[1]);if(timeInSeconds>=startSeconds&&timeInSeconds<endSeconds){return true}}return false}_triggerEvent(eventName){const customEvent=new CustomEvent(`timepicker:${eventName}`,{bubbles:true,detail:{time:this.selectedValue,formattedTime:this.selectedValue!==null?this._formatTime(this.selectedValue):null}});this.element.dispatchEvent(customEvent);if(eventName==="change"){const changeEvent=new Event("change",{bubbles:true});this.element.dispatchEvent(changeEvent);if(this.timeInput&&this.timeInput!==this.element){this.timeInput.dispatchEvent(new Event("change",{bubbles:true}))}}}getTime(){return this.selectedValue}getFormattedTime(){if(this.selectedValue===null){return null}return this._formatTime(this.selectedValue)}setTime(seconds){this.selectValue(seconds)}destroy(){if(this.list&&this.list.parentNode){this.list.parentNode.removeChild(this.list)}if(this.timeInput&&this.timeInput!==this.element&&this.timeInput.parentNode){this.timeInput.removeEventListener("change",this._onTimeInputChange);this.timeInput.removeEventListener("input",this._onTimeInputChange);this.timeInput.parentNode.removeChild(this.timeInput)}this.element.removeEventListener("click",this._onClick);this.element.removeEventListener("focus",this._onFocus);this.element.removeEventListener("blur",this._onBlur);this.element.removeEventListener("input",this._onInput);this.element.removeEventListener("keydown",this._onKeydown);if(this.settings.closeOnWindowScroll){window.removeEventListener("scroll",this._onWindowScroll)}window.removeEventListener("resize",this._onWindowResize);delete this.element._timePickerJS}}function TimePickerJSFactory(selector,options={}){let elements;if(typeof selector==="string"){elements=document.querySelectorAll(selector)}else if(selector instanceof NodeList||selector instanceof HTMLCollection){elements=selector}else if(Array.isArray(selector)){elements=selector}else{elements=[selector]}if(elements.length===1){const element=elements[0];if(element._timePickerJS){return element._timePickerJS}const instance=new TimePickerJS(element,options);element._timePickerJS=instance;return instance}else{return Array.from(elements).map(element=>{if(element._timePickerJS){return element._timePickerJS}const instance=new TimePickerJS(element,options);element._timePickerJS=instance;return instance})}}global.TimePickerJS=TimePickerJS})(window);